using System;
using Server;
using Server.Mobiles;

namespace Server.Items
{
	public class VestmentOfHighPriest : BaseLevelOuterTorso
	{
		public override int ArtifactRarity{ get{ return 45; } }

		public override int BasePhysicalResistance{ get{ return 20; } }
		public override int BaseColdResistance{ get{ return 10; } }
		
		private int m_ResCharges = 0;
		private int m_MaxResCharges = 20;		
		public DateTime m_NextSpecial;
	
		public DateTime NextSpecial { get { return m_NextSpecial; } set { m_NextSpecial = value; } }
		public int CheatChance { get { return Math.Max( 5, ( this.Level / 6 ) ) ; } }
		public int MaxResCharges { get { return 20; } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int ResCharges { get { return m_ResCharges; } set { m_ResCharges = Math.Min( value, m_MaxResCharges ); } }

		[Constructable]
		public VestmentOfHighPriest() : base( 0x1F03, 2633 )
		{
			Weight = 3.0;
			Name = "<basefont color=cyan>Vestment of High Priest";
			
			SkillBonuses.SetValues( 0, SkillName.Healing, 20 );
			SkillBonuses.SetValues( 1, SkillName.Anatomy, 20 );
			Attributes.Luck = 120;
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=cyan>Cheat Death {0}%\nCharges: {1} / {2}<basefont color=White>", CheatChance, m_ResCharges, MaxResCharges );
		}
		
		public override bool CanEquip( Mobile from )
		{
			if ( from.AccessLevel == AccessLevel.Player && from.Skills[SkillName.Healing].Base < 120.0 )
			{
            from.SendMessage( "Pouze legendarni lecitel muze obleci tuto robu!" );
            return false;
         }
			
         return base.CanEquip( from );
		}
		
		public override void OnDoubleClick( Mobile m )
		{
			if( Parent != m || m.HasTrade )
			{
				m.SendMessage( "Pro pouziti roby si ji musis nasadit!" );
			}
			else
			{
				if ( ItemID == 0x2683 || ItemID == 0x2684 )
				{
					m.SendMessage( "{0} jsi si kapuci.", (m.Female)?"Stahnula":"Stahnul" );
					m.PlaySound( 0x57 );
					ItemID = 0x1F03;
					Weight = 3.0;
					m.RemoveItem(this);
					m.EquipItem(this);

				}
				else if ( ItemID == 0x1F03 || ItemID == 0x1F04 )
				{
					m.SendMessage( "{0} jsi si kapuci pres hlavu.", (m.Female)?"Pretahnula":"Pretahnul" );
					m.PlaySound( 0x57 );
					ItemID = 0x2683;
					Weight = 3.0;
					m.RemoveItem(this);
					m.EquipItem(this);
				}
			}
		}
		
		/*public override bool OnEquip( Mobile from )
		{
         DoSolidHue( from );
        	return base.OnEquip( from );
		}*/
		
		public override void OnRemoved( object parent )
		{
			if ( parent is Mobile )
				((Mobile)parent).SolidHueOverride = -1;


	     base.OnRemoved( parent );
		}
		
		public void DoSolidHue( Mobile from )
		{
			from.SolidHueOverride = this.Hue;
         Timer.DelayCall( TimeSpan.FromMinutes( 2.0 ), new TimerStateCallback( EndSolidHue ), new object[]{ from } );
      }
      
		private void EndSolidHue( object state )
		{
			object[] args = (object[])state;
			Mobile from = (Mobile) args[0];

			if ( from != null )
			   from.SolidHueOverride = -1;
      }
		
		public VestmentOfHighPriest( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 1 );
			
			writer.Write( m_ResCharges );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
			
			m_ResCharges = reader.ReadInt();
		}
	}
}